
% Henrik Jensen, Ivan Petrella, Sren Hove Ravn, Emiliano Santoro
% Leverage and Deepening Business Cycle Skewness
%
% This is the main file for running the dynamic simulations and reporting
% the results in the paper

% Before running, you need to update the path at the bottom of this file
% and in the file Plot_Simulated_Data (in the subfolder Computestats)

close all;
clear; clc;

Simulnumber    = 501  ;        % Number of simulations
Simulperiods   = 2200 ;        % # periods we want + # discarded initial periods 
Discardperiods = 200  ;


% Construct vector of LTVs - note, these will apply to impatient household!
vect= [0.67; 0.70; 0.75; 0.80; 0.85; 0.9];

% Loop over range of LTVs

for cl=1:length(vect)

    sbarloop=vect(cl);
   
    dynare Skewness_runmodel noclearall;

    Skewness_DynamicSimulation;
    
    close all

end

ShapingData_yci;

% Now change directory to the subfolder Computestats
cd 'C:\Users\dlx832\Desktop\Step 2 Simulation\Computestats'

Plot_SimulatedData;